<?php
/*--------------------------------------------------------------
   Icon.php 2021-06-22
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects;

use InvalidArgumentException;
use Webmozart\Assert\Assert;

class Icon
{
    /**
     * @var string
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(string $value)
    {
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(string $url): self
    {
        Assert::stringNotEmpty($url);
        
        if (filter_var($url, FILTER_VALIDATE_URL) === false) {
            throw new InvalidArgumentException("Icon URL '$url' is invalid");
        }
        
        return new self($url);
    }
    
    
    /**
     * Create instance.
     */
    public static function createUsingData(string $data): self
    {
        Assert::stringNotEmpty($data);
        Assert::startsWith($data, "data:");
        
        return new self($data);
    }
    
    
    /**
     * Return value.
     */
    public function value(): string
    {
        return $this->value;
    }
}